unit BrowseOrders;

interface

uses
  System.Collections, System.ComponentModel,
  System.Data, System.Drawing, System.Web, System.Web.SessionState,
  System.Web.UI, System.Web.UI.WebControls, System.Web.UI.HtmlControls,
  Borland.Data.Web, Borland.Data.Provider, Borland.Data.Common,
  System.Globalization, System.Data.Common, System.Configuration;

type
  TWebForm1 = class(System.Web.UI.Page)
  {$REGION 'Designer Managed Code'}
  strict private
    procedure InitializeComponent;
    procedure btnDefineQuery_Click(sender: System.Object; e: System.EventArgs);
    procedure dbwdsBrwsOrd_OnApplyChangesRequest(sender: System.Object; e: Borland.Data.Web.WebControlEventArgs);
    procedure cbActivateQuery_CheckedChanged(sender: System.Object; e: System.EventArgs);
  {$ENDREGION}
  strict private
    procedure ViewConstraints;
    procedure CreateMasterDetailRelation;
    procedure Page_Load(sender: System.Object; e: System.EventArgs);
  strict protected
    bdpConnBrwsOrds: Borland.Data.Provider.BdpConnection;
    bdpSelectCommand1: Borland.Data.Provider.BdpCommand;
    DtAdapCust: Borland.Data.Provider.BdpDataAdapter;
    bdpSelectCommand2: Borland.Data.Provider.BdpCommand;
    DtAdapCustOrd: Borland.Data.Provider.BdpDataAdapter;
    dbwdsBrwsOrd: Borland.Data.Web.DBWebDataSource;
    dbwgCustOrd: Borland.Data.Web.DBWebGrid;
    dsBrwsOrds: System.Data.DataSet;
    DataTable1: System.Data.DataTable;
    DataColumn1: System.Data.DataColumn;
    DataColumn2: System.Data.DataColumn;
    DataColumn3: System.Data.DataColumn;
    DataColumn4: System.Data.DataColumn;
    DataColumn5: System.Data.DataColumn;
    DataColumn6: System.Data.DataColumn;
    DataColumn7: System.Data.DataColumn;
    DataColumn8: System.Data.DataColumn;
    DataColumn9: System.Data.DataColumn;
    DataColumn10: System.Data.DataColumn;
    DataColumn11: System.Data.DataColumn;
    DataColumn12: System.Data.DataColumn;
    DataColumn13: System.Data.DataColumn;
    DataColumn14: System.Data.DataColumn;
    DataColumn15: System.Data.DataColumn;
    DataColumn16: System.Data.DataColumn;
    DataColumn17: System.Data.DataColumn;
    DataColumn18: System.Data.DataColumn;
    DataColumn19: System.Data.DataColumn;
    DataColumn20: System.Data.DataColumn;
    DataColumn21: System.Data.DataColumn;
    DataTable2: System.Data.DataTable;
    DataColumn22: System.Data.DataColumn;
    DataColumn23: System.Data.DataColumn;
    DataColumn24: System.Data.DataColumn;
    DataColumn25: System.Data.DataColumn;
    DataColumn26: System.Data.DataColumn;
    DataColumn27: System.Data.DataColumn;
    DataColumn28: System.Data.DataColumn;
    DataColumn29: System.Data.DataColumn;
    DataColumn30: System.Data.DataColumn;
    DataColumn31: System.Data.DataColumn;
    DataColumn32: System.Data.DataColumn;
    DataColumn33: System.Data.DataColumn;
    DataColumn34: System.Data.DataColumn;
    dbwgCust: Borland.Data.Web.DBWebGrid;
    dbwnCustOrd: Borland.Data.Web.DBWebNavigator;
    frmBrowseOrders: System.Web.UI.HtmlControls.HtmlForm;
    btnDefineQuery: System.Web.UI.WebControls.Button;
    cbActivateQuery: System.Web.UI.WebControls.CheckBox;
    procedure OnInit(e: EventArgs); override;
  private
    { Private Declarations }
  public
    { Public Declarations }
  end;

implementation

{$REGION 'Designer Managed Code'}
/// <summary>
/// Required method for Designer support -- do not modify
/// the contents of this method with the code editor.
/// </summary>
procedure TWebForm1.InitializeComponent;
type
  TArrayOfSystem_Data_Common_DataTableMapping = array of System.Data.Common.DataTableMapping;
  TArrayOfSystem_Data_Common_DataColumnMapping = array of System.Data.Common.DataColumnMapping;
  TArrayOfSystem_Data_DataRelation = array of System.Data.DataRelation;
  TArrayOfString = array of string;
  TArrayOfSystem_Data_DataTable = array of System.Data.DataTable;
  TArrayOfSystem_Data_DataColumn = array of System.Data.DataColumn;
  TArrayOfSystem_Data_Constraint = array of System.Data.Constraint;
var
  configurationAppSettings: System.Configuration.AppSettingsReader;
begin
  configurationAppSettings := System.Configuration.AppSettingsReader.Create;
  Self.bdpConnBrwsOrds := Borland.Data.Provider.BdpConnection.Create;
  Self.DtAdapCust := Borland.Data.Provider.BdpDataAdapter.Create;
  Self.dsBrwsOrds := System.Data.DataSet.Create;
  Self.DataTable1 := System.Data.DataTable.Create;
  Self.DataColumn1 := System.Data.DataColumn.Create;
  Self.DataColumn2 := System.Data.DataColumn.Create;
  Self.DataColumn3 := System.Data.DataColumn.Create;
  Self.DataColumn4 := System.Data.DataColumn.Create;
  Self.DataColumn5 := System.Data.DataColumn.Create;
  Self.DataColumn6 := System.Data.DataColumn.Create;
  Self.DataColumn7 := System.Data.DataColumn.Create;
  Self.DataColumn8 := System.Data.DataColumn.Create;
  Self.DataColumn9 := System.Data.DataColumn.Create;
  Self.DataColumn10 := System.Data.DataColumn.Create;
  Self.DataColumn11 := System.Data.DataColumn.Create;
  Self.DataColumn12 := System.Data.DataColumn.Create;
  Self.DataColumn13 := System.Data.DataColumn.Create;
  Self.DataTable2 := System.Data.DataTable.Create;
  Self.DataColumn14 := System.Data.DataColumn.Create;
  Self.DataColumn15 := System.Data.DataColumn.Create;
  Self.DataColumn16 := System.Data.DataColumn.Create;
  Self.DataColumn17 := System.Data.DataColumn.Create;
  Self.DataColumn18 := System.Data.DataColumn.Create;
  Self.DataColumn19 := System.Data.DataColumn.Create;
  Self.DataColumn20 := System.Data.DataColumn.Create;
  Self.DataColumn21 := System.Data.DataColumn.Create;
  Self.DataColumn22 := System.Data.DataColumn.Create;
  Self.DataColumn23 := System.Data.DataColumn.Create;
  Self.DataColumn24 := System.Data.DataColumn.Create;
  Self.DataColumn25 := System.Data.DataColumn.Create;
  Self.DataColumn26 := System.Data.DataColumn.Create;
  Self.DataColumn27 := System.Data.DataColumn.Create;
  Self.DataColumn28 := System.Data.DataColumn.Create;
  Self.DataColumn29 := System.Data.DataColumn.Create;
  Self.DataColumn30 := System.Data.DataColumn.Create;
  Self.DataColumn31 := System.Data.DataColumn.Create;
  Self.DataColumn32 := System.Data.DataColumn.Create;
  Self.DataColumn33 := System.Data.DataColumn.Create;
  Self.DataColumn34 := System.Data.DataColumn.Create;
  Self.bdpSelectCommand1 := Borland.Data.Provider.BdpCommand.Create;
  Self.DtAdapCustOrd := Borland.Data.Provider.BdpDataAdapter.Create;
  Self.bdpSelectCommand2 := Borland.Data.Provider.BdpCommand.Create;
  Self.dbwdsBrwsOrd := Borland.Data.Web.DBWebDataSource.Create;
  (System.ComponentModel.ISupportInitialize(Self.DtAdapCust)).BeginInit;
  (System.ComponentModel.ISupportInitialize(Self.dsBrwsOrds)).BeginInit;
  (System.ComponentModel.ISupportInitialize(Self.DataTable1)).BeginInit;
  (System.ComponentModel.ISupportInitialize(Self.DataTable2)).BeginInit;
  (System.ComponentModel.ISupportInitialize(Self.DtAdapCustOrd)).BeginInit;
  (System.ComponentModel.ISupportInitialize(Self.dbwdsBrwsOrd)).BeginInit;
  Include(Self.btnDefineQuery.Click, Self.btnDefineQuery_Click);
  Include(Self.cbActivateQuery.CheckedChanged, Self.cbActivateQuery_CheckedChanged);
  // 
  // bdpConnBrwsOrds
  // 
  Self.bdpConnBrwsOrds.ConnectionOptions := 'waitonlocks=False;commitretain=' +
  'False;sqldialect=3;transaction isolation=ReadCommitted;servercharset=;rol' +
  'ename=myrole';
  Self.bdpConnBrwsOrds.ConnectionString := (string(configurationAppSettings.GetValue('C' +
    'onnectionString', TypeOf(string))));
  // 
  // DtAdapCust
  // 
  Self.DtAdapCust.Active := True;
  Self.DtAdapCust.DataSet := Self.dsBrwsOrds;
  Self.DtAdapCust.DataTable := Self.DataTable1;
  Self.DtAdapCust.MaxRecords := 10000;
  Self.DtAdapCust.SelectCommand := Self.bdpSelectCommand1;
  Self.DtAdapCust.StartRecord := 0;
  Self.DtAdapCust.TableMappings.AddRange(TArrayOfSystem_Data_Common_DataTableMapping.Create(System.Data.Common.DataTableMapping.Create('T' +
          'able', 'CUSTOMER', TArrayOfSystem_Data_Common_DataColumnMapping.Create(System.Data.Common.DataColumnMapping.Create('C' +
                'USTNO', 'CUSTNO'), System.Data.Common.DataColumnMapping.Create('C' +
                'OMPANY', 'COMPANY'), System.Data.Common.DataColumnMapping.Create('A' +
                'DDR1', 'ADDR1'), System.Data.Common.DataColumnMapping.Create('A' +
                'DDR2', 'ADDR2'), System.Data.Common.DataColumnMapping.Create('C' +
                'ITY', 'CITY'), System.Data.Common.DataColumnMapping.Create('S' +
                'TATE', 'STATE'), System.Data.Common.DataColumnMapping.Create('Z' +
                'IP', 'ZIP'), System.Data.Common.DataColumnMapping.Create('C' +
                'OUNTRY', 'COUNTRY'), System.Data.Common.DataColumnMapping.Create('P' +
                'HONE', 'PHONE'), System.Data.Common.DataColumnMapping.Create('F' +
                'AX', 'FAX'), System.Data.Common.DataColumnMapping.Create('T' +
                'AXRATE', 'TAXRATE'), System.Data.Common.DataColumnMapping.Create('C' +
                'ONTACT', 'CONTACT'), System.Data.Common.DataColumnMapping.Create('L' +
                'ASTINVOICEDATE', 'LASTINVOICEDATE')))));
  // 
  // dsBrwsOrds
  // 
  Self.dsBrwsOrds.DataSetName := 'dsCustomerOrders';
  Self.dsBrwsOrds.EnforceConstraints := False;
  Self.dsBrwsOrds.Locale := System.Globalization.CultureInfo.Create('en-US');
  Self.dsBrwsOrds.Relations.AddRange(TArrayOfSystem_Data_DataRelation.Create(System.Data.DataRelation.Create('R' +
          'elation1', 'CUSTOMER', 'ORDERS', TArrayOfString.Create('CUSTNO'), 
            TArrayOfString.Create('CUSTNO'), False)));
  Self.dsBrwsOrds.Tables.AddRange(TArrayOfSystem_Data_DataTable.Create(Self.DataTable1, 
          Self.DataTable2));
  // 
  // DataTable1
  // 
  Self.DataTable1.Columns.AddRange(TArrayOfSystem_Data_DataColumn.Create(Self.DataColumn1, 
          Self.DataColumn2, Self.DataColumn3, Self.DataColumn4, Self.DataColumn5, 
          Self.DataColumn6, Self.DataColumn7, Self.DataColumn8, Self.DataColumn9, 
          Self.DataColumn10, Self.DataColumn11, Self.DataColumn12, Self.DataColumn13));
  Self.DataTable1.Constraints.AddRange(TArrayOfSystem_Data_Constraint.Create(System.Data.UniqueConstraint.Create('C' +
          'onstraint1', TArrayOfString.Create('CUSTNO'), True)));
  Self.DataTable1.PrimaryKey := TArrayOfSystem_Data_DataColumn.Create(Self.DataColumn1);
  Self.DataTable1.TableName := 'CUSTOMER';
  // 
  // DataColumn1
  // 
  Self.DataColumn1.AllowDBNull := False;
  Self.DataColumn1.ColumnName := 'CUSTNO';
  Self.DataColumn1.DataType := TypeOf(System.Double);
  Self.DataColumn1.ReadOnly := True;
  // 
  // DataColumn2
  // 
  Self.DataColumn2.ColumnName := 'COMPANY';
  Self.DataColumn2.MaxLength := 31;
  // 
  // DataColumn3
  // 
  Self.DataColumn3.ColumnName := 'ADDR1';
  Self.DataColumn3.MaxLength := 31;
  // 
  // DataColumn4
  // 
  Self.DataColumn4.ColumnName := 'ADDR2';
  Self.DataColumn4.MaxLength := 31;
  // 
  // DataColumn5
  // 
  Self.DataColumn5.ColumnName := 'CITY';
  Self.DataColumn5.MaxLength := 16;
  // 
  // DataColumn6
  // 
  Self.DataColumn6.ColumnName := 'STATE';
  Self.DataColumn6.MaxLength := 21;
  // 
  // DataColumn7
  // 
  Self.DataColumn7.ColumnName := 'ZIP';
  Self.DataColumn7.MaxLength := 11;
  // 
  // DataColumn8
  // 
  Self.DataColumn8.ColumnName := 'COUNTRY';
  Self.DataColumn8.MaxLength := 21;
  // 
  // DataColumn9
  // 
  Self.DataColumn9.ColumnName := 'PHONE';
  Self.DataColumn9.MaxLength := 16;
  // 
  // DataColumn10
  // 
  Self.DataColumn10.ColumnName := 'FAX';
  Self.DataColumn10.MaxLength := 16;
  // 
  // DataColumn11
  // 
  Self.DataColumn11.ColumnName := 'TAXRATE';
  Self.DataColumn11.DataType := TypeOf(System.Double);
  // 
  // DataColumn12
  // 
  Self.DataColumn12.ColumnName := 'CONTACT';
  Self.DataColumn12.MaxLength := 21;
  // 
  // DataColumn13
  // 
  Self.DataColumn13.ColumnName := 'LASTINVOICEDATE';
  Self.DataColumn13.DataType := TypeOf(System.DateTime);
  // 
  // DataTable2
  // 
  Self.DataTable2.Columns.AddRange(TArrayOfSystem_Data_DataColumn.Create(Self.DataColumn14, 
          Self.DataColumn15, Self.DataColumn16, Self.DataColumn17, Self.DataColumn18, 
          Self.DataColumn19, Self.DataColumn20, Self.DataColumn21, Self.DataColumn22, 
          Self.DataColumn23, Self.DataColumn24, Self.DataColumn25, Self.DataColumn26, 
          Self.DataColumn27, Self.DataColumn28, Self.DataColumn29, Self.DataColumn30, 
          Self.DataColumn31, Self.DataColumn32, Self.DataColumn33, Self.DataColumn34));
  Self.DataTable2.Constraints.AddRange(TArrayOfSystem_Data_Constraint.Create(System.Data.UniqueConstraint.Create('C' +
          'onstraint1', TArrayOfString.Create('ORDERNO'), True), System.Data.ForeignKeyConstraint.Create('R' +
          'elation1', 'CUSTOMER', TArrayOfString.Create('CUSTNO'), TArrayOfString.Create('C' +
              'USTNO'), System.Data.AcceptRejectRule.None, System.Data.Rule.Cascade, 
            System.Data.Rule.Cascade)));
  Self.DataTable2.PrimaryKey := TArrayOfSystem_Data_DataColumn.Create(Self.DataColumn14);
  Self.DataTable2.TableName := 'ORDERS';
  // 
  // DataColumn14
  // 
  Self.DataColumn14.AllowDBNull := False;
  Self.DataColumn14.ColumnName := 'ORDERNO';
  Self.DataColumn14.DataType := TypeOf(System.Double);
  // 
  // DataColumn15
  // 
  Self.DataColumn15.AllowDBNull := False;
  Self.DataColumn15.ColumnName := 'CUSTNO';
  Self.DataColumn15.DataType := TypeOf(System.Double);
  Self.DataColumn15.ReadOnly := True;
  // 
  // DataColumn16
  // 
  Self.DataColumn16.ColumnName := 'SALEDATE';
  Self.DataColumn16.DataType := TypeOf(System.DateTime);
  // 
  // DataColumn17
  // 
  Self.DataColumn17.ColumnName := 'SHIPDATE';
  Self.DataColumn17.DataType := TypeOf(System.DateTime);
  // 
  // DataColumn18
  // 
  Self.DataColumn18.AllowDBNull := False;
  Self.DataColumn18.ColumnName := 'EMPNO';
  Self.DataColumn18.DataType := TypeOf(Integer);
  // 
  // DataColumn19
  // 
  Self.DataColumn19.ColumnName := 'SHIPTOCONTACT';
  Self.DataColumn19.MaxLength := 21;
  // 
  // DataColumn20
  // 
  Self.DataColumn20.ColumnName := 'SHIPTOADDR1';
  Self.DataColumn20.MaxLength := 31;
  // 
  // DataColumn21
  // 
  Self.DataColumn21.ColumnName := 'SHIPTOADDR2';
  Self.DataColumn21.MaxLength := 31;
  // 
  // DataColumn22
  // 
  Self.DataColumn22.ColumnName := 'SHIPTOCITY';
  Self.DataColumn22.MaxLength := 16;
  // 
  // DataColumn23
  // 
  Self.DataColumn23.ColumnName := 'SHIPTOSTATE';
  Self.DataColumn23.MaxLength := 21;
  // 
  // DataColumn24
  // 
  Self.DataColumn24.ColumnName := 'SHIPTOZIP';
  Self.DataColumn24.MaxLength := 11;
  // 
  // DataColumn25
  // 
  Self.DataColumn25.ColumnName := 'SHIPTOCOUNTRY';
  Self.DataColumn25.MaxLength := 21;
  // 
  // DataColumn26
  // 
  Self.DataColumn26.ColumnName := 'SHIPTOPHONE';
  Self.DataColumn26.MaxLength := 16;
  // 
  // DataColumn27
  // 
  Self.DataColumn27.ColumnName := 'SHIPVIA';
  Self.DataColumn27.MaxLength := 8;
  // 
  // DataColumn28
  // 
  Self.DataColumn28.ColumnName := 'PO';
  Self.DataColumn28.MaxLength := 16;
  // 
  // DataColumn29
  // 
  Self.DataColumn29.ColumnName := 'TERMS';
  Self.DataColumn29.MaxLength := 7;
  // 
  // DataColumn30
  // 
  Self.DataColumn30.ColumnName := 'PAYMENTMETHOD';
  Self.DataColumn30.MaxLength := 8;
  // 
  // DataColumn31
  // 
  Self.DataColumn31.ColumnName := 'ITEMSTOTAL';
  Self.DataColumn31.DataType := TypeOf(System.Double);
  // 
  // DataColumn32
  // 
  Self.DataColumn32.ColumnName := 'TAXRATE';
  Self.DataColumn32.DataType := TypeOf(System.Double);
  // 
  // DataColumn33
  // 
  Self.DataColumn33.ColumnName := 'FREIGHT';
  Self.DataColumn33.DataType := TypeOf(System.Double);
  // 
  // DataColumn34
  // 
  Self.DataColumn34.ColumnName := 'AMOUNTPAID';
  Self.DataColumn34.DataType := TypeOf(System.Double);
  // 
  // bdpSelectCommand1
  // 
  Self.bdpSelectCommand1.CommandOptions := nil;
  Self.bdpSelectCommand1.CommandText := 'SELECT CUSTNO, COMPANY, ADDR1, ADDR' +
  '2, CITY, STATE, ZIP, COUNTRY, PHONE, FAX, TAXRATE, CONTACT, LASTINVOICEDA' +
  'TE FROM CUSTOMER';
  Self.bdpSelectCommand1.CommandType := System.Data.CommandType.Text;
  Self.bdpSelectCommand1.Connection := Self.bdpConnBrwsOrds;
  Self.bdpSelectCommand1.ParameterCount := (SmallInt(0));
  Self.bdpSelectCommand1.SchemaName := nil;
  Self.bdpSelectCommand1.Transaction := nil;
  Self.bdpSelectCommand1.UpdatedRowSource := System.Data.UpdateRowSource.None;
  // 
  // DtAdapCustOrd
  // 
  Self.DtAdapCustOrd.Active := True;
  Self.DtAdapCustOrd.DataSet := Self.dsBrwsOrds;
  Self.DtAdapCustOrd.DataTable := Self.DataTable2;
  Self.DtAdapCustOrd.MaxRecords := 10000;
  Self.DtAdapCustOrd.SelectCommand := Self.bdpSelectCommand2;
  Self.DtAdapCustOrd.StartRecord := 0;
  Self.DtAdapCustOrd.TableMappings.AddRange(TArrayOfSystem_Data_Common_DataTableMapping.Create(System.Data.Common.DataTableMapping.Create('T' +
          'able', 'ORDERS', TArrayOfSystem_Data_Common_DataColumnMapping.Create(System.Data.Common.DataColumnMapping.Create('O' +
                'RDERNO', 'ORDERNO'), System.Data.Common.DataColumnMapping.Create('C' +
                'USTNO', 'CUSTNO'), System.Data.Common.DataColumnMapping.Create('S' +
                'ALEDATE', 'SALEDATE'), System.Data.Common.DataColumnMapping.Create('S' +
                'HIPDATE', 'SHIPDATE'), System.Data.Common.DataColumnMapping.Create('E' +
                'MPNO', 'EMPNO'), System.Data.Common.DataColumnMapping.Create('S' +
                'HIPTOCONTACT', 'SHIPTOCONTACT'), System.Data.Common.DataColumnMapping.Create('S' +
                'HIPTOADDR1', 'SHIPTOADDR1'), System.Data.Common.DataColumnMapping.Create('S' +
                'HIPTOADDR2', 'SHIPTOADDR2'), System.Data.Common.DataColumnMapping.Create('S' +
                'HIPTOCITY', 'SHIPTOCITY'), System.Data.Common.DataColumnMapping.Create('S' +
                'HIPTOSTATE', 'SHIPTOSTATE'), System.Data.Common.DataColumnMapping.Create('S' +
                'HIPTOZIP', 'SHIPTOZIP'), System.Data.Common.DataColumnMapping.Create('S' +
                'HIPTOCOUNTRY', 'SHIPTOCOUNTRY'), System.Data.Common.DataColumnMapping.Create('S' +
                'HIPTOPHONE', 'SHIPTOPHONE'), System.Data.Common.DataColumnMapping.Create('S' +
                'HIPVIA', 'SHIPVIA'), System.Data.Common.DataColumnMapping.Create('P' +
                'O', 'PO'), System.Data.Common.DataColumnMapping.Create('TER' +
                'MS', 'TERMS'), System.Data.Common.DataColumnMapping.Create('P' +
                'AYMENTMETHOD', 'PAYMENTMETHOD'), System.Data.Common.DataColumnMapping.Create('I' +
                'TEMSTOTAL', 'ITEMSTOTAL'), System.Data.Common.DataColumnMapping.Create('T' +
                'AXRATE', 'TAXRATE'), System.Data.Common.DataColumnMapping.Create('F' +
                'REIGHT', 'FREIGHT'), System.Data.Common.DataColumnMapping.Create('A' +
                'MOUNTPAID', 'AMOUNTPAID')))));
  // 
  // bdpSelectCommand2
  // 
  Self.bdpSelectCommand2.CommandOptions := nil;
  Self.bdpSelectCommand2.CommandText := 'SELECT ORDERNO, CUSTNO, SALEDATE, S' +
  'HIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIP' +
  'TOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYME' +
  'NTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID FROM ORDERS';
  Self.bdpSelectCommand2.CommandType := System.Data.CommandType.Text;
  Self.bdpSelectCommand2.Connection := Self.bdpConnBrwsOrds;
  Self.bdpSelectCommand2.ParameterCount := (SmallInt(0));
  Self.bdpSelectCommand2.SchemaName := nil;
  Self.bdpSelectCommand2.Transaction := nil;
  Self.bdpSelectCommand2.UpdatedRowSource := System.Data.UpdateRowSource.None;
  // 
  // dbwdsBrwsOrd
  // 
  Self.dbwdsBrwsOrd.DataSource := Self.dsBrwsOrds;
  Self.dbwdsBrwsOrd.ErrorDlgBackColor := System.Drawing.Color.Azure;
  Self.dbwdsBrwsOrd.ErrorDlgBorderColor := System.Drawing.Color.Red;
  Self.dbwdsBrwsOrd.ErrorDlgForeColor := System.Drawing.Color.Black;
  Include(Self.dbwdsBrwsOrd.OnApplyChangesRequest, Self.dbwdsBrwsOrd_OnApplyChangesRequest);
  Include(Self.Load, Self.Page_Load);
  (System.ComponentModel.ISupportInitialize(Self.DtAdapCust)).EndInit;
  (System.ComponentModel.ISupportInitialize(Self.dsBrwsOrds)).EndInit;
  (System.ComponentModel.ISupportInitialize(Self.DataTable1)).EndInit;
  (System.ComponentModel.ISupportInitialize(Self.DataTable2)).EndInit;
  (System.ComponentModel.ISupportInitialize(Self.DtAdapCustOrd)).EndInit;
  (System.ComponentModel.ISupportInitialize(Self.dbwdsBrwsOrd)).EndInit;
end;
{$ENDREGION}

procedure TWebForm1.ViewConstraints;
var
  cs : Constraint;
  cName : string;
  cType : string;
begin
  for cs in dsBrwsOrds.Tables[1].Constraints do
  begin
    cName :=  cs.ConstraintName;
    cType := cs.GetType.ToString();
  end;
end;

procedure TWebForm1.CreateMasterDetailRelation;
var
  ParentCol, ChildCol : DataColumn;
  CustOrderDtRelation : DataRelation;
begin
  if (dsBrwsOrds.Relations.Count = 1) and (dsBrwsOrds.Relations.Item[0] <> nil) then
    dsBrwsOrds.Relations.RemoveAt(0);
  ParentCol := dsBrwsOrds.Tables['CUSTOMER'].Columns['CUSTNO'];
  ChildCol := dsBrwsOrds.Tables['ORDERS'].Columns['CUSTNO'];
  CustOrderDtRelation := DataRelation.Create('CustomerOrders', ParentCol, ChildCol);
  dsBrwsOrds.Relations.Add(CustOrderDtRelation);
end;

procedure TWebForm1.Page_Load(sender: System.Object; e: System.EventArgs);
var
  DefaultCustomerQuery : string;
begin
  // TODO: Put user code to initialize the page here
  if not IsPostBack then
  begin
    DefaultCustomerQuery := string(Cache['DefaultCustomerQuery']);
    if (DefaultCustomerQuery = nil) or (DefaultCustomerQuery.Length = 0) then
      Cache['DefaultCustomerQuery'] := DtAdapCust.SelectCommand.CommandText;
  end;
(*
  try
      dc := DataColumn.Create('AmountDue', &Type.GetType('System.Double'));
      dc.Expression := '(ITEMSTOTAL + (ITEMSTOTAL * TAXRATE/100) + FREIGHT) - AMOUNTPAID';
      dataSet1.Tables[1].Columns.Add(dc);
  except
  end;
*)
end;

procedure TWebForm1.OnInit(e: EventArgs);
begin
  //
  // Required for Designer support
  //
  InitializeComponent;
  inherited OnInit(e);
end;

procedure TWebForm1.cbActivateQuery_CheckedChanged(sender: System.Object; e: System.EventArgs);
var
  startdate, enddate, sQuery : string;
begin
//  try
    if (cbActivateQuery.Checked) then
    begin
      startdate := string(Cache.Get('startdate'));
      enddate := string(Cache.Get('enddate'));
      sQuery := 'SELECT CUSTNO, COMPANY, LASTINVOICEDATE, PHONE ' +
              'FROM CUSTOMER WHERE LASTINVOICEDATE BETWEEN ';
      sQuery := sQuery + '''' + startdate + '''' + ' AND ' + '''' + enddate + '''';
      DtAdapCust.Active := False;
      DtAdapCust.SelectCommand.CommandText := sQuery;
//      ViewConstraints; //used for debugging
      dsBrwsOrds.Relations.RemoveAt(0);
      dsBrwsOrds.Tables[1].Constraints.RemoveAt(1);
      DtAdapCust.Active := True;
      CreateMasterDetailRelation;
      dbwdsBrwsOrd.ClearSessionChanges(Page);
      dbwgCust.SelectedIndex := 0;
    end
    else
    begin
      if IsPostBack then
      begin
        if Cache['DefaultCustomerQuery'] <> nil then
        begin
          DtAdapCust.Active := False;
          DtAdapCust.SelectCommand.CommandText := string(Cache['DefaultCustomerQuery']);
          dsBrwsOrds.Relations.RemoveAt(0);
          dsBrwsOrds.Tables[1].Constraints.RemoveAt(1);
          DtAdapCust.Active := True;
          CreateMasterDetailRelation;
          dbwdsBrwsOrd.ClearSessionChanges(Page);
          dbwgCust.SelectedIndex := 0;
        end
      end
    end;
//    except
// handle exceptions in a webpage
//      on E: Exception do test := E.Message;
//    end;
end;

procedure TWebForm1.dbwdsBrwsOrd_OnApplyChangesRequest(sender: System.Object;
  e: Borland.Data.Web.WebControlEventArgs);
begin
  DtAdapCust.AutoUpdate();
end;

procedure TWebForm1.btnDefineQuery_Click(sender: System.Object; e: System.EventArgs);
begin
  Response.Redirect('QueryCustomer.aspx');
end;
end.

